/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Command;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.InputEvent;

public class MouseCommand
implements Command {
    private Robot robot;
    private String action;
    private int step = 100;
    private int scrollStep = 5;

    public static void main(String[] args) throws Exception {
        new MouseCommand(new Robot(), "center").doAction();
        new Robot().delay(400);
        new MouseCommand(new Robot(), "double click").doAction();
    }

    public MouseCommand(Robot robot, String action) {
        this(robot, action, "");
    }

    public MouseCommand(Robot robot, String action, String stepInfo) {
        this.robot = robot;
        this.action = action;
        if ("small".equals(stepInfo)) {
            this.step = 10;
            this.scrollStep = 1;
        } else if ("big".equals(stepInfo)) {
            this.step = 200;
            this.scrollStep = 10;
        }
    }

    @Override
    public boolean doAction() {
        Point a = MouseInfo.getPointerInfo().getLocation();
        if ("move left".equals(this.action)) {
            this.robot.mouseMove(a.x - this.step, a.y);
        } else if ("move right".equals(this.action)) {
            this.robot.mouseMove(a.x + this.step, a.y);
        } else if ("move top".equals(this.action)) {
            this.robot.mouseMove(a.x, a.y - this.step);
        } else if ("move bottom".equals(this.action)) {
            this.robot.mouseMove(a.x, a.y + this.step);
        } else if ("center".equals(this.action)) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.robot.mouseMove(screenSize.width / 2, screenSize.height / 2);
        } else if ("scroll down".equals(this.action)) {
            this.robot.mouseWheel(this.scrollStep);
        } else if ("scroll up".equals(this.action)) {
            this.robot.mouseWheel(-this.scrollStep);
        } else if ("press".equals(this.action)) {
            this.robot.mousePress(InputEvent.getMaskForButton(1));
        } else if ("release".equals(this.action)) {
            this.robot.mouseRelease(InputEvent.getMaskForButton(1));
        } else if ("click".equals(this.action)) {
            this.robot.mousePress(InputEvent.getMaskForButton(1));
            this.robot.mouseRelease(InputEvent.getMaskForButton(1));
        } else if ("double click".equals(this.action)) {
            this.robot.mousePress(InputEvent.getMaskForButton(1));
            this.robot.mouseRelease(InputEvent.getMaskForButton(1));
            this.robot.mousePress(InputEvent.getMaskForButton(1));
            this.robot.mouseRelease(InputEvent.getMaskForButton(1));
        } else if ("right click".equals(this.action)) {
            this.robot.mousePress(InputEvent.getMaskForButton(3));
            this.robot.mouseRelease(InputEvent.getMaskForButton(3));
        }
        return true;
    }

    public String toString() {
        return this.action + ", " + this.step + " scroll:" + this.scrollStep;
    }
}

