/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.DesktopCtrlUI;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Helper {
    public static void main(String[] args) {
        Helper.showDialog(null, "test");
    }

    public static void close(Closeable is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean empty(String fixedInput) {
        return fixedInput == null || fixedInput.isEmpty();
    }

    public static String innerTrim(String str) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean previousSpace = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') {
                previousSpace = true;
                continue;
            }
            if (previousSpace) {
                sb.append(' ');
            }
            previousSpace = false;
            sb.append(c);
        }
        return sb.toString().trim();
    }

    public static Set<String> toLower(Set<String> set) {
        LinkedHashSet<String> res = new LinkedHashSet<String>(set.size());
        for (String s : set) {
            res.add(s.toLowerCase());
        }
        return res;
    }

    public static void copy(InputStream is, FileWriter fileWriter) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        BufferedWriter writer = new BufferedWriter(fileWriter);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
            writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static int wordcount(String fixedInput) {
        if (Helper.empty(fixedInput)) {
            return 0;
        }
        return fixedInput.trim().split(" ").length;
    }

    public static int count(String input, String substr) {
        if (Helper.empty(input)) {
            return 0;
        }
        int count = 0;
        int start = 0;
        int sublength = substr.length();
        while ((start = input.indexOf(substr, start)) >= 0) {
            ++count;
            start += sublength;
        }
        return count;
    }

    public static Set<String> set(String ... strs) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(strs.length);
        for (int i = 0; i < strs.length; ++i) {
            set.add(strs[i]);
        }
        return set;
    }

    public static String getParam(String action, String key, String defaultParam) {
        if (!action.startsWith(key)) {
            return defaultParam;
        }
        if (action.length() <= key.length()) {
            return defaultParam;
        }
        String param = action.substring(key.length()).trim();
        if (param.isEmpty()) {
            return defaultParam;
        }
        return param;
    }

    public static String encodeUrl(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return str;
        }
    }

    public static String getHome() {
        return System.getProperty("user.home") + File.separatorChar + ".desktop-ctrl" + File.separatorChar;
    }

    static void useDefaultIfNotExistent(String file, boolean forceWrite) throws IOException {
        String fullFile = Helper.getHome() + file;
        if (!new File(fullFile).exists() || forceWrite) {
            System.out.println("Writing default file to " + fullFile);
            new File(Helper.getHome()).mkdirs();
            Helper.copy(DesktopCtrlUI.class.getResourceAsStream(file), new FileWriter(fullFile));
        }
    }

    public static int showDialog(final JFrame frame, final String text) {
        final AtomicInteger ref = new AtomicInteger(2);
        final CountDownLatch latch = new CountDownLatch(1);
        Helper.doUI(new Runnable(){

            @Override
            public void run() {
                final JDialog dialog = frame == null ? new JDialog() : new JDialog(frame);
                Container cont = dialog.getContentPane();
                cont.setLayout(new FlowLayout());
                cont.add(new JLabel(text));
                JPanel buttons = new JPanel();
                JButton ok = new JButton("Ok");
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ref.set(0);
                        dialog.setVisible(false);
                        latch.countDown();
                    }
                });
                JButton cancel = new JButton("Cancel");
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                        latch.countDown();
                    }
                });
                buttons.add(ok);
                buttons.add(cancel);
                cont.add(buttons);
                dialog.pack();
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                dialog.toFront();
            }
        });
        try {
            latch.await();
            return ref.get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void doUI(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

