/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.pannous.desktopctrl.client.CommandTable;
import com.pannous.desktopctrl.client.ConfigLoader;
import com.pannous.desktopctrl.client.Configuration;
import com.pannous.desktopctrl.client.Engine;
import com.pannous.desktopctrl.client.Handler;
import com.pannous.desktopctrl.client.Helper;
import com.pannous.desktopctrl.client.Keyboard;
import com.pannous.desktopctrl.client.TextController;
import com.pannous.desktopctrl.client.TextTransfer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DesktopCtrlUI {
    private boolean sayIntoTextArea = false;
    private TextController text2UI;
    private JFrame frame = new JFrame("Dictation Client");
    private JLabel infoLabel = new JLabel();
    private JTextArea text = new JTextArea(30, 60);
    private String password;
    private String ownName;
    private String userURL;
    private ArrayListModel allCommandsTableModel = new ArrayListModel();
    private Handler handler = new Handler("en");
    private Keyboard keyboard;
    private Engine engine;
    private Set<String> allowedClients = new LinkedHashSet<String>();
    private ConfigLoader loader;
    private Configuration config;

    public static void main(String[] args) throws Exception {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setDefaultIconSize(new Dimension(18, 18));
        String lafName = LookUtils.IS_OS_WINDOWS_XP ? Options.getCrossPlatformLookAndFeelClassName() : Options.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
        new DesktopCtrlUI().startUI();
    }

    public void startUI() throws Exception {
        this.config = new Configuration().load();
        this.loader = new ConfigLoader(this.allCommandsTableModel);
        Robot robot = new Robot();
        this.keyboard = new Keyboard(robot);
        this.engine = new Engine(robot, this.keyboard);
        this.engine.setNative(this.config.getNative());
        this.text2UI = this.keyboard.isUnix() ? this.keyboard : new TextTransfer(this.keyboard);
        final String host = this.config.getHost();
        final int port = this.config.getPort();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DesktopCtrlUI.this.infoLabel.setText("Trying to connect to " + host + ":" + port);
                DesktopCtrlUI.this.frame.setLayout(new BorderLayout());
                DesktopCtrlUI.this.frame.setSize(800, 600);
                JScrollPane textScroll = new JScrollPane(DesktopCtrlUI.this.text);
                textScroll.setMinimumSize(new Dimension(800, 600));
                DesktopCtrlUI.this.frame.add((Component)textScroll, "Center");
                DesktopCtrlUI.this.infoLabel.setPreferredSize(new Dimension(300, 100));
                DesktopCtrlUI.this.frame.add((Component)DesktopCtrlUI.this.infoLabel, "North");
                CommandTable table = new CommandTable(DesktopCtrlUI.this.allCommandsTableModel);
                DesktopCtrlUI.this.frame.add((Component)new JScrollPane(table), "South");
                DesktopCtrlUI.this.frame.setDefaultCloseOperation(3);
                DesktopCtrlUI.this.frame.setVisible(true);
            }
        });
        this.password = this.config.getPassword();
        if (this.password.isEmpty()) {
            do {
                JPasswordField pw = new JPasswordField("");
                pw.requestFocus();
                JOptionPane.showMessageDialog(this.frame, pw, "Enter secure phrase", 3);
                this.password = new String(pw.getPassword());
            } while (this.password.isEmpty());
        }
        this.ownName = this.password;
        this.userURL = host + ":" + port;
        this.startSocket(host, port);
        this.loader.startReloadThread();
    }

    void startSocket(final String address, final int port) {
        new Thread("desktop ctrl thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Socket socket = null;
                    try {
                        DesktopCtrlUI.this.log("reconnect ...");
                        socket = new Socket(address, port);
                        DesktopCtrlUI.this.handleIO(socket);
                    }
                    catch (ConnectException ex) {
                        DesktopCtrlUI.this.log("server not ready:" + ex.getMessage());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        DesktopCtrlUI.this.logToUser("Error:" + ex.getMessage());
                    }
                    finally {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        DesktopCtrlUI.this.log("leaving thread");
                        return;
                    }
                }
            }
        }.start();
    }

    private void handleIO(Socket socket) throws Exception {
        PrintWriter bw = new PrintWriter(socket.getOutputStream());
        bw.println("!iam:" + this.ownName);
        bw.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String str = in.readLine();
        if (str == null) {
            return;
        }
        this.logToUser("logged in at desktop control server " + this.userURL + " waiting for a client");
        this.log("DesktopCtrlUI connected this client (" + this.ownName + ") to desktop control server at " + this.userURL);
        String clientName = null;
        while ((str = in.readLine()) != null) {
            this.log("DesktopCtrlUI " + clientName + " " + str);
            String lowerResponse = str.toLowerCase();
            if (lowerResponse.equals("!noonethrere")) {
                this.log("ERROR: client did not tell its name => " + str);
                continue;
            }
            if (lowerResponse.startsWith("!connected:")) {
                String user = lowerResponse.substring(11);
                if (user == null || user.isEmpty() || this.allowedClients.contains(user)) continue;
                int res = Helper.showDialog(this.frame, user + " wants to connect. Allow?");
                if (res == 0) {
                    this.allowedClients.add(user);
                    bw.println("!connect:" + user);
                    bw.flush();
                    clientName = user;
                    this.logToUser(new Date() + " client connected at " + this.userURL + " with " + user);
                    continue;
                }
                this.log("WARN:denied access for " + user);
                continue;
            }
            if ("!connected!".equals(lowerResponse) || lowerResponse.startsWith("!connecting") || lowerResponse.startsWith("!hi") || lowerResponse.startsWith("!lang:") || clientName == null) continue;
            if (lowerResponse.startsWith("ping:")) {
                bw.println("PONG:" + System.currentTimeMillis());
                bw.flush();
                continue;
            }
            String cmdsStr = lowerResponse;
            List<String> strokes = this.handler.getMatchingCommands(cmdsStr, this.loader.getAllCommands());
            if (!strokes.isEmpty()) {
                int counter = 0;
                for (String stroke : strokes) {
                    if (counter > 0) {
                        Thread.sleep(400L);
                    }
                    this.engine.execute(stroke);
                    ++counter;
                }
                continue;
            }
            if (this.sayIntoTextArea) {
                this.addText(cmdsStr, " ");
                continue;
            }
            this.text2UI.write(cmdsStr);
        }
    }

    void addText(final String str, final String separator) {
        Helper.doUI(new Runnable(){

            @Override
            public void run() {
                DesktopCtrlUI.this.text.setText(DesktopCtrlUI.this.text.getText() + separator + str);
            }
        });
    }

    void logToUser(final String text) {
        Helper.doUI(new Runnable(){

            @Override
            public void run() {
                DesktopCtrlUI.this.infoLabel.setText(text);
            }
        });
    }

    private void log(String str) {
        System.out.println(str);
    }
}

