/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Helper;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class Configuration {
    private Properties config;
    private String CONFIG = "config.properties";

    public synchronized Configuration load() {
        this.config = this.load(this.CONFIG);
        return this;
    }

    public boolean getNative() {
        return Boolean.parseBoolean(this.config.getProperty("native.enabled", "false"));
    }

    private synchronized Properties load(String file) {
        try {
            Helper.useDefaultIfNotExistent(file, false);
            String fullFile = Helper.getHome() + file;
            System.out.println("Reading config file from " + fullFile);
            Properties properties = new Properties();
            properties.load(new FileReader(fullFile));
            return properties;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getHost() {
        return this.config.getProperty("host");
    }

    public int getPort() {
        return Integer.parseInt(this.config.getProperty("port", "1234"));
    }

    public String getPassword() {
        return this.config.getProperty("password", "");
    }
}

